import { UniqueChecker } from './UniqueChecker';
import { CollectionPost } from './CollectionPost';
import { CollectionPostAdded } from './events/CollectionPostAdded';
import { CollectionPostRemoved } from './events/CollectionPostRemoved';
type CollectionEvent = CollectionPostAdded | CollectionPostRemoved;
export declare class Collection {
    events: CollectionEvent[];
    id: string;
    title: string;
    private _slug;
    get slug(): string;
    setSlug(slug: string, uniqueChecker: UniqueChecker): Promise<void>;
    description: string;
    type: 'manual' | 'automatic';
    _filter: string | null;
    get filter(): string | null;
    set filter(value: string | null);
    featureImage: string | null;
    createdAt: Date;
    updatedAt: Date;
    get deletable(): boolean;
    private _deleted;
    private _posts;
    get posts(): string[];
    get deleted(): boolean;
    set deleted(value: boolean);
    postMatchesFilter(post: CollectionPost): any;
    /**
     * @param post {{id: string}} - The post to add to the collection
     * @param index {number} - The index to insert the post at, use negative numbers to count from the end.
     */
    addPost(post: CollectionPost, index?: number): boolean;
    removePost(id: string): void;
    includesPost(id: string): boolean;
    removeAllPosts(): void;
    private constructor();
    toJSON(): {
        id: string;
        title: string;
        slug: string;
        description: string;
        type: "manual" | "automatic";
        filter: string | null;
        featureImage: string | null;
        createdAt: Date;
        updatedAt: Date;
        posts: string[];
    };
    static validateDateField(date: any, fieldName: string): Date;
    static create(data: any): Promise<Collection>;
}
export {};
