"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CollectionsRepositoryInMemory = void 0;
const in_memory_repository_1 = require("@tryghost/in-memory-repository");
class CollectionsRepositoryInMemory extends in_memory_repository_1.InMemoryRepository {
    toPrimitive(entity) {
        return entity.toJSON();
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    createTransaction(cb) {
        return cb(null);
    }
    async getBySlug(slug) {
        return this.store.find(item => item.slug === slug) || null;
    }
}
exports.CollectionsRepositoryInMemory = CollectionsRepositoryInMemory;
//# sourceMappingURL=CollectionsRepositoryInMemory.js.map